import os
import django
import random
from datetime import timedelta, date
from faker import Faker

# 👇 FIX THIS LINE with your actual Django project name (the one with settings.py)
os.environ.setdefault("DJANGO_SETTINGS_MODULE", "passMCQ.settings")
django.setup()

# Import your models
from app.models import (
    Student,
    Subject,
    Chapter,
    ClassLevel,
    Subscription,
    Exam,
    Question,
    Choice,
    ExamQuestion,
    ExamResult,
)

fake = Faker()

# Create or get subjects
subjects = [
    Subject.objects.get_or_create(name=subj)[0]
    for subj in ['Math', 'Science', 'English', 'History']
]

# Create or get class levels
class_levels = [
    ClassLevel.objects.get_or_create(name=cls)[0]
    for cls in ['Class 6', 'Class 7', 'Class 8']
]

# Create or get chapters
chapters = [
    Chapter.objects.get_or_create(name=fake.word().capitalize())[0]
    for _ in range(5)
]

# Create fake students
for _ in range(5):
    student = Student.objects.create(
        name=fake.name(),
        email=fake.email(),
        phone=fake.phone_number(),
        date_of_birth=fake.date_of_birth(),
        gender=random.choice(['M', 'F']),
        address=fake.address(),
    )

    class_level = random.choice(class_levels)

    # Create a subscription
    sub = Subscription.objects.create(
        student=student,
        subscription_type=random.choice(['YEAR', 'SUBJECT', 'BUNDLE']),
        class_level=class_level,
        start_date=date.today(),
        end_date=date.today() + timedelta(days=365)
    )
    sub.subjects.set(random.sample(subjects, k=2))

    # Create exam
    subject = random.choice(subjects)
    exam = Exam.objects.create(
        title=fake.sentence(nb_words=4),
        student=student,
        class_level=class_level,
        subject=subject,
        exam_category=random.choice(['Mock', 'Chapter', 'Full']),
        duration_minutes=30,
        is_custom=False
    )

    # Add questions
    for _ in range(3):
        question = Question.objects.create(
            text=fake.sentence(nb_words=8),
            question_type='MCQ',
            subject=subject,
            chapter=random.choice(chapters),
            exam_category=random.choice(['Mock', 'Chapter', 'Full']),
            difficulty=random.randint(1, 5)
        )

        # Add choices
        for i in range(4):
            Choice.objects.create(
                question=question,
                text=fake.word().capitalize(),
                is_correct=(i == 0)
            )

        ExamQuestion.objects.create(exam=exam, question=question)

    # Create exam result
    ExamResult.objects.create(
        exam=exam,
        score=random.uniform(50, 100),
        correct_answers=random.randint(1, 5),
        wrong_answers=random.randint(0, 2),
        time_taken_seconds=random.randint(60, 300)
    )

print("✅ Fake data generated successfully.")
