from django.contrib import admin
from django.urls import path
from django.conf import settings
from django.conf.urls.static import static
from . import views
from dought import views as dought_views



urlpatterns = [
    # Home & Dashboard
    path('', views.home, name='home'),
    path('dashboard/', views.DashboardPage, name='dashboard'),

    # Subscription
    path('dashboard/subscription/', views.SubscriptionPage, name='subscription_page'),
    path('dashboard/subscription/annual/<uuid:pk>/', views.checkoutPageAnnual, name='checkout_annual'),
    path('dashboard/subscription/subject/<uuid:pk>/', views.checkoutPageSubjectBased, name='checkout_subject'),
    path('dashboard/subscription/bundle/<uuid:pk>/', views.checkoutPageBundle, name='checkout_bundle'),
    path('process-subscription/', views.process_subscription, name='process_subscription'),
    path('subscription/annual/', views.AnnualSubscriptionPage, name='annual_subscription_page'),
    path('subscription/subject/', views.SubjectSubscriptionPage, name='subject_subscription_page'),
    path('subscription/bundle/', views.BundleSubscriptionPage, name='bundle_subscription_page'),

    # MCQ Flow
    path('dashboard/mcq/', views.MCQ_Page, name='mcq_test'),
    path('dashboard/mcq/subject/<uuid:subject_id>/', views.mcq_chapter_page, name='mcq_chapter_page'),
    path('dashboard/mcq/preview/', views.preview_page, name='preview_page'),
    path('dashboard/mcq/start/', views.start_exam, name='start_exam'),
    path('dashboard/mcq/exam/<uuid:exam_id>/', views.exam_page, name='exam_page'),
    path('dashboard/mcq/finish/<uuid:exam_id>/', views.finish_exam, name='finish_exam'),
    path('dashboard/mcq/results/<uuid:exam_id>/', views.exam_results, name='exam_results'),
    path('dashboard/mcq/retake/<uuid:exam_id>/', views.retake_exam, name='retake_exam'), # New URL for retake
    path('dashboard/mcq/all-results/', views.TotalResultPage, name='total_results_page'), # New URL for total results


    # path('dought/', dought_views.dought_page, name='dought_page'),
    # path('dought/post_doubt/', dought_views.post_doubt, name='post_doubt'),

    path('dashboard/add-bulk-questions/', views.bulk_add_questions, name='bulk_add_questions'),
    
    # Question Bank
    path('question-bank/', views.question_bank, name='bank'),
    path('question-bank/subject/<uuid:subject_id>/', views.subject_questions, name='subject_questions'),
    path('question-bank/chapter/<uuid:chapter_id>/', views.chapter_questions, name='chapter_questions'),
    path('question-bank/question/<uuid:question_id>/', views.question_detail, name='question_detail'),
]

if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
    urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)