from django.urls import path
from django.conf import settings
from django.conf.urls.static import static
from .views import *

urlpatterns = [
    path('subscription/', subscriptionPage, name="subscription"),
    path('subscription/annual/', AnnualSubscriptionPage, name="annual_subscription"),
    path('subscription/subjectbased/', SubjectSubscriptionPage, name="subject_subscription"),
    path('subscription/bundle/', BundleSubscriptionPage, name="bundle_subscription"),
    path('checkout/annual/<str:pk>', checkoutPageAnnual, name="checkout_annual"),
    path('checkout/subject-based/<str:pk>', checkoutPageSubjectBased, name="checkout_subject_based"),
    path('checkout/bundle/<str:pk>', checkoutPageBundle, name="checkout_bundle"),
    path('process/subscription/', process_subscription, name="process_subscription"),
    path('free/subscription/<str:subscription_type>/<uuid:pk>/', process_free_subscription, name="free_subscription"),

]

if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
    urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)